import { Request } from 'express-validator/lib/base';
import { Context, ReadonlyContext } from 'express-validator/lib/context';
import { ContextBuilder } from 'express-validator/lib/context-builder';
import { SelectFields } from 'express-validator/lib/field-selection';
import { Result } from 'express-validator/lib/validation-result';
import { ContextRunner, ResultWithContext } from 'express-validator/lib/chain/context-runner';
export declare class ResultWithContextImpl extends Result implements ResultWithContext {
    readonly context: ReadonlyContext;
    constructor(context: ReadonlyContext);
}
export declare class ContextRunnerImpl implements ContextRunner {
    private readonly builderOrContext;
    private readonly selectFields;
    constructor(builderOrContext: ContextBuilder | Context, selectFields?: SelectFields);
    run(req: Request, options?: {
        dryRun?: boolean;
    }): Promise<ResultWithContextImpl>;
}
